#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "typedef.h"

struct hdr {
	uchar	size;
	uchar	sum;
	uchar	method[5];
	ulong	packed;
	ulong	original;
	ulong	time;
	ushort	attr;
	uchar	fnlen;
	uchar	fname[256];
} header;

FILE *f0, *f1;

char title[] = "DATA\tsegment\tbyte public 'DATA'\n"
               "\t\tpublic\tNAM_\n"
               "NAM_\tdb\t\t";

char foot[]  = "\n"
               "DATA\tends\n"
               "\t\tend\n";

int main(int argc, char *argv[])
{
	int i, c, d;
	char *p;

	f0 = fopen(argv[1], "rb");
	if (f0 == NULL) exit(1);
	f1 = fopen(argv[2], "w");
	if (f1 == NULL) exit(1);

	fread(&header, 1, 2, f0);
	fread(header.method, 1, header.size, f0);
	do {
		p = strstr(title, "NAM");
		if (p) strncpy(p, argv[1], 3);
	} while (p);
	fprintf(f1, "%s", title);
	fprintf(f1, "0%02lxh, 0%02lxh, 0%02lxh, 0%02lxh",
			header.packed & 0xff, (header.packed >> 8) & 0xff,
			header.original & 0xff, (header.original >> 8) & 0xff);
	i = 4;
	d = getc(f0);
	while ((c = getc(f0)) != EOF) {
		if (i == 8) {
			fprintf(f1, "\n\t\tdb\t\t");
			i = 0;
		} else {
			fputc(',', f1);
			fputc(' ', f1);
		}
		fprintf(f1, "0%02xh", d);
		d = c;
		i++;
	}
	fprintf(f1, "%s", foot);
	fclose(f1);
	return 0;
}
